# ResTv2
ResTv2 for Object Detection by detectron2

This repo contains the supported code and configuration files to reproduce object detection results of ResTv2. It is based on [detectron2](https://github.com/facebookresearch/detectron2).


## Results and Models

### Mask R-CNN

|   Backbone   | Pretrain | Lr Schd | box mAP | mask mAP | #params | FLOPs |                           config                            | log | model |
|:------------:| :---: | :---: |:-------:|:--------:|:-------:| :---: |:-----------------------------------------------------------:| :---: |:-----:|
| ResTv2-T FPN | ImageNet-1K | 3x |  47.6   |   43.2   |  49.9   | - | [config](configs/ResTv2/mask_rcnn_restv2_tiny_FPN_3x.yaml)  | - |  -    |
| ResTv2-S FPN | ImageNet-1K | 3x |  48.1   |   43.3   |  60.7   | - | [config](configs/ResTv2/mask_rcnn_restv2_small_FPN_3x.yaml) | - |  -    |
| ResTv2-B FPN | ImageNet-1K | 3x |  48.7   |   43.9   |  75.5   | - | [config](configs/ResTv2/mask_rcnn_restv2_base_FPN_3x.yaml)  | - |  -    |


## Usage
Please refer to [get_started.md](https://detectron2.readthedocs.io/en/latest/tutorials/getting_started.html) for installation and dataset preparation.

note: you need convert the original pretrained weights to d2 format by [convert_to_d2.py](convert_to_d2.py)

## References
- [detectron2](https://github.com/facebookresearch/detectron2)
